<?php

namespace App\Controllers;

use App\Models\UserModel;

class AuthController extends BaseController
{
    protected $userModel;

    public function __construct()
    {
        $this->userModel = new UserModel();
    }

    /**
     * Halaman untuk memilih role admin (Activities, Biodata, Education)
     */
    public function selectRole()
    {
        $data = [
            'title' => 'Pilih Admin Login'
        ];

        return view('auth/select_role', $data);
    }

    /**
     * Halaman form login berdasarkan role yang dipilih
     */
    public function login($role = null)
    {
        $allowedRoles = ['admin_activities', 'admin_biodata', 'admin_education'];
        
        if (!$role || !in_array($role, $allowedRoles)) {
            return redirect()->to('auth/login')->with('error', 'Role tidak valid!');
        }

        $data = [
            'title' => 'Login ' . ucfirst(str_replace('admin_', '', $role)),
            'role' => $role,
            'roleName' => $this->getRoleName($role)
        ];

        return view('auth/login_form', $data);
    }

    /**
     * Proses login
     */
    public function processLogin($role = null)
    {
        $allowedRoles = ['admin_activities', 'admin_biodata', 'admin_education'];
        
        if (!$role || !in_array($role, $allowedRoles)) {
            return redirect()->to('auth/login')->with('error', 'Role tidak valid!');
        }

        $username = $this->request->getPost('username');
        $password = $this->request->getPost('password');

        if (empty($username) || empty($password)) {
            return redirect()->to('auth/login/' . $role)->with('error', 'Username dan password harus diisi!');
        }

        $user = $this->userModel->where('username', $username)
            ->where('role', $role)
            ->first();

        if ($user && password_verify($password, $user['password'])) {
            session()->set([
                'user_id' => $user['id'],
                'username' => $user['username'],
                'user_role' => $user['role'],
                'logged_in' => true
            ]);

            return redirect()->to('admin/dashboard')->with('success', 'Login berhasil!');
        } else {
            return redirect()->to('auth/login/' . $role)->with('error', 'Username atau password salah!');
        }
    }

    /**
     * Logout
     */
    public function logout()
    {
        session()->destroy();
        return redirect()->to('/')->with('success', 'Logout berhasil!');
    }

    /**
     * Helper untuk mendapatkan nama role yang lebih user-friendly
     */
    private function getRoleName($role)
    {
        $names = [
            'admin_activities' => 'Admin Aktivitas',
            'admin_biodata' => 'Admin Biodata',
            'admin_education' => 'Admin Pendidikan'
        ];

        return $names[$role] ?? $role;
    }
}

